@extends('layouts.vendor.app')

@section('title',translate('messages.restaurant_wallet'))

@push('css_or_js')

@endpush

@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
     <div class="page-header">
            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <h2 class="page-header-title text-capitalize">
                        <div class="card-header-icon d-inline-flex mr-2 img">
                            <img src="{{dynamicAsset('/public/assets/admin/img/image_90.png')}}" alt="public">
                        </div>
                        <span>
                            {{translate('messages.restaurant_wallet')}}
                        </span>
                    </h2>
                </div>
            </div>
        </div>
<!-- End Page Header -->


        <?php
                    $wallet = \App\Models\RestaurantWallet::where('vendor_id',\App\CentralLogics\Helpers::get_vendor_id())->first();
                    if(isset($wallet)==false){
                        \Illuminate\Support\Facades\DB::table('restaurant_wallets')->insert([
                            'vendor_id'=>\App\CentralLogics\Helpers::get_vendor_id(),
                            'created_at'=>now(),
                            'updated_at'=>now()
                        ]);
                        $wallet = \App\Models\RestaurantWallet::where('vendor_id',\App\CentralLogics\Helpers::get_vendor_id())->first();
                    }
            ?>
@include('vendor-views.wallet.partials._balance_data',['wallet'=>$wallet])


                <div class="card-header border-0 py-2">
                    <div class="search--button-wrapper">
                        <h2 class="card-title">
                            {{ translate('Total_Disbursements') }} <span class="badge badge-soft-secondary ml-2" id="countItems">{{ $disbursements->total() }}</span>
                        </h2>
                        <form class="search-form">
                            <!-- Search -->
                            <div class="input--group input-group input-group-merge input-group-flush">
                                <input class="form-control" value="{{ request()?->search  ?? null }}" placeholder="{{ translate('search_by_ID') }}" name="search">
                                <button type="submit" class="btn btn--secondary secondary-cmn"><i class="tio-search"></i></button>
                            </div>
                            <!-- End Search -->
                        </form>
                        <!-- Static Export Button -->
                        <div class="hs-unfold ml-3">
                            <a class="js-hs-unfold-invoker btn btn-sm btn-white dropdown-toggle btn export-btn btn-outline-primary btn--primary font--sm" href="javascript:;"
                                data-hs-unfold-options='{
                                    "target": "#usersExportDropdown",
                                    "type": "css-animation"
                                }'>
                                <i class="tio-download-to mr-1"></i> {{translate('messages.export')}}
                            </a>
                            <div id="usersExportDropdown"
                                    class="hs-unfold-content dropdown-unfold dropdown-menu dropdown-menu-sm-right">
                                <span class="dropdown-header">{{translate('messages.download_options')}}</span>
                                <a id="export-excel" class="dropdown-item" href="{{route('vendor.wallet.export', ['type'=>'excel',request()->getQueryString()])}}">
                                    <img class="avatar avatar-xss avatar-4by3 mr-2" src="{{dynamicAsset('public/assets/admin')}}/svg/components/excel.svg" alt="Image Description">
                                    {{translate('messages.excel')}}
                                </a>
                                <a id="export-csv" class="dropdown-item" href="{{route('vendor.wallet.export', ['type'=>'csv',request()->getQueryString()])}}">
                                    <img class="avatar avatar-xss avatar-4by3 mr-2" src="{{dynamicAsset('public/assets/admin')}}/svg/components/placeholder-csv-format.svg" alt="Image Description">
                                    {{translate('messages.csv')}}
                                </a>

                            </div>
                        </div>
                        <!-- Static Export Button -->

                        <!-- Action button after check table row -->
                        <div id="action-section" class="d--none">
                            <button class="btn btn-danger btn-outline-danger" id="cancel">{{ translate('cancel') }}</button>
                            <button class="btn btn-success" id="complete">{{ translate('complete') }}</button>
                        </div>
                        <!-- Action button after check table row -->

                    </div>
                </div>









                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-thead-bordered table-align-middle card-table">
                            <thead>
                                <tr>
                                    <th>{{ translate('sl') }}</th>
                                    <th>{{ translate('ID') }}</th>
                                    <th>{{ translate('Created_at') }}</th>
                                    <th>{{ translate('Disburse_Amount') }}</th>
                                    <th>{{ translate('Payment_method') }}</th>
                                    <th>{{ translate('Payout_Date') }}</th>
                                    <th>{{ translate('status') }}</th>
                                    <th>
                                        <div class="text-center">
                                            {{ translate('action') }}
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($disbursements as $key => $restaurant)
                                    <tr>
                                        <td>
                                            <span class="font-weight-bold">{{$key+ $disbursements->firstItem()}}</span>
                                        </td>
                                        <td>
                                            <span class="font-weight-bold">{{$restaurant->disbursement_id}}</span>
                                        </td>
                                        <td>
                                            {{ \App\CentralLogics\Helpers::time_date_format( $restaurant->created_at )  }}

                                        </td>

                                        <td>
                                            {{\App\CentralLogics\Helpers::format_currency($restaurant['disbursement_amount'])}}
                                        </td>
                                        <td>
                                            <div>
                                                {{$restaurant?->withdraw_method?->method_name ?? translate('Default_method')}}
                                            </div>
                                        </td>
                                        <td>
                                            @php($restaurant_disbursement_waiting_time = (int)\App\Models\BusinessSetting::where('key', 'restaurant_disbursement_waiting_time')->first()?->value ?? 0)
                                            <div>
                                                {{ $restaurant->created_at->addDays($restaurant_disbursement_waiting_time)->format('d-M-y')  }}
                                                <small>
                                                    {{  translate('Estimated') }}
                                                </small>
                                            </div>
                                        </td>
                                        <td>
                                            @if($restaurant->status=='pending')
                                                <label class="badge badge-soft-primary">{{ translate('pending') }}</label>
                                            @elseif($restaurant->status=='completed')
                                                <label class="badge badge-soft-success">{{ translate('Completed') }}</label>
                                            @else
                                                <label class="badge badge-soft-danger">{{ translate('canceled') }}</label>
                                            @endif
                                        </td>


                                        <td>
                                            <div class="btn--container justify-content-center">
                                                <a class="btn btn-sm btn--primary btn-outline-primary action-btn" data-toggle="modal" data-target="#payment-info-{{$restaurant->id}}" title="{{ translate('View_Details') }}">
                                                    <i class="tio-visible"></i>
                                                    </a>

                                            </div>
                                        </td>
                                        <div class="modal fade" id="payment-info-{{$restaurant->id}}">
                                            <div class="modal-dialog modal-xl">
                                                <div class="modal-content">
                                                    <div class="modal-header pb-4">
                                                        <button type="button" class="payment-modal-close btn-close border-0 outline-0 bg-transparent" data-dismiss="modal">
                                                            <i class="tio-clear"></i>
                                                        </button>
                                                        <div class="w-100 text-center">
                                                            <h2 class="mb-2">{{ translate('Payment_Information') }}</h2>
                                                            <div>
                                                                <span class="mr-2">{{ translate('Disbursement_ID') }}</span>
                                                                <strong>#{{$restaurant->disbursement_id}}</strong>
                                                            </div>
                                                            <div class="mt-2">
                                                                <span class="mr-2">{{ translate('status') }}</span>
                                                                @if($restaurant->status=='pending')
                                                                    <label class="badge badge-soft-primary">{{ translate('pending') }}</label>
                                                                @elseif($restaurant->status=='completed')
                                                                    <label class="badge badge-soft-success">{{ translate('Completed') }}</label>
                                                                @else
                                                                    <label class="badge badge-soft-danger">{{ translate('canceled') }}</label>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="card shadow--card-2">
                                                            <div class="card-body">
                                                                <div class="d-flex flex-wrap payment-info-modal-info p-xl-4">
                                                                    <div class="item">
                                                                        <h5>{{ translate('Restaurant_Information') }}</h5>
                                                                        <ul class="item-list">
                                                                            <li class="d-flex flex-wrap">
                                                                                <span class="name">{{ translate('name') }}</span>
                                                                                <span>:</span>
                                                                                <strong>{{$restaurant?->restaurant?->name}}</strong>
                                                                            </li>
                                                                            <li class="d-flex flex-wrap">
                                                                                <span class="name">{{ translate('contact') }}</span>
                                                                                <span>:</span>
                                                                                <strong>{{$restaurant?->restaurant?->phone}}</strong>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                    <div class="item">
                                                                        <h5>{{ translate('Owner_Information') }}</h5>
                                                                        <ul class="item-list">
                                                                            <li class="d-flex flex-wrap">
                                                                                <span class="name">{{ translate('name') }}</span>
                                                                                <span>:</span>
                                                                                <strong>{{$restaurant->restaurant->vendor->f_name}} {{$restaurant->restaurant->vendor->l_name}}</strong>
                                                                            </li>
                                                                            <li class="d-flex flex-wrap">
                                                                                <span class="name">{{ translate('email') }}</span>
                                                                                <span>:</span>
                                                                                <strong>{{$restaurant->restaurant->vendor->email}}</strong>
                                                                            </li>
                                                                        </ul>
                                                                    </div>
                                                                    <div class="item w-100">
                                                                        <h5>{{ translate('Account_Information') }}</h5>
                                                                        <ul class="item-list">
                                                                            <li class="d-flex flex-wrap">
                                                                                <span class="name">{{ translate('payment_method') }}</span>
                                                                                <span>:</span>
                                                                                <strong>{{$restaurant?->withdraw_method?->method_name ?? translate('Default_method')}}</strong>
                                                                            </li>
                                                                            <li class="d-flex flex-wrap">
                                                                                <span class="name">{{ translate('amount') }}</span>
                                                                                <span>:</span>
                                                                                <strong>{{\App\CentralLogics\Helpers::format_currency($restaurant['disbursement_amount'])}}</strong>
                                                                            </li>
                                                                            @forelse(json_decode($restaurant?->withdraw_method?->method_fields, true) ?? [] as $key=> $item)
                                                                            <li class="d-flex flex-wrap">
                                                                                <span class="name">{{  translate($key) }}</span>
                                                                                <span>:</span>
                                                                                <strong>{{$item}}</strong>
                                                                            </li>
                                                                            @empty

                                                                            @endforelse

                                                                        </ul>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @if(count($disbursements) === 0)
                            <div class="empty--data">
                                <img src="{{dynamicAsset('/public/assets/admin/img/empty.png')}}" alt="public">
                                <h5>
                                    {{translate('no_data_found')}}
                                </h5>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="card-footer pt-0 border-0">
                    {{$disbursements->links()}}
                </div>
            </div>
        </div>
    </div>
</div>


                <div class="modal fade" id="payment_model" tabindex="-1"  role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{translate('messages.Pay_Via_Online')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>

                        </div>
                        <form action="{{ route('vendor.wallet.make_payment') }}" method="POST" class="needs-validation">
                        <div class="modal-body">
                                @csrf
                                <input type="hidden" value="{{ \App\CentralLogics\Helpers::get_restaurant_id() }}" name="restaurant_id"/>
                                <input type="hidden" value="{{ abs($wallet->collected_cash) }}" name="amount"/>
                                <h5 class="mb-5 ">{{ translate('Pay_Via_Online') }} &nbsp; <small>({{ translate('Faster_&_secure_way_to_pay_bill') }})</small></h5>
                                <div class="row g-3">
                                    @forelse ($data as $item)
                                        <div class="col-sm-6">
                                            <div class="d-flex gap-3 align-items-center">
                                                <input type="radio" required id="{{$item['gateway'] }}" name="payment_gateway" value="{{$item['gateway'] }}">
                                                <label for="{{$item['gateway'] }}" class="d-flex align-items-center gap-3 mb-0">
                                                    <img height="24" src="{{ dynamicStorage('storage/app/public/payment_modules/gateway_image/'. $item['gateway_image']) }}" alt="">
                                                    {{ $item['gateway_title'] }}
                                                </label>
                                            </div>
                                        </div>
                                    @empty
                                    <h1>{{ translate('no_payment_gateway_found') }}</h1>
                                    @endforelse
                                </div>
                        </div>

                        <div class="modal-footer">
                            <button id="reset_btn" type="reset" data-dismiss="modal" class="btn btn-secondary" >{{ translate('Close') }} </button>
                            <button type="submit" class="btn btn-primary">{{ translate('Proceed') }}</button>
                        </div>
                        </form>
                    </div>
                    </div>
                </div>


                <div class="modal fade" id="Adjust_wallet" tabindex="-1"  role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{translate('messages.Adjust_Wallet')}}  </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                            </button>

                        </div>
                        <form action="{{ route('vendor.wallet.make_wallet_adjustment') }}" method="POST" class="needs-validation">
                        <div class="modal-body">
                                @csrf
                                <h5 class="mb-5 ">{{ translate('This_will_adjust_the_collected_cash_on_your_earning') }} </h5>
                        </div>

                        <div class="modal-footer">
                            <button id="reset_btn" type="reset" data-dismiss="modal" class="btn btn-secondary" >{{ translate('Close') }} </button>
                            <button type="submit" class="btn btn-primary">{{ translate('Proceed') }}</button>
                        </div>
                        </form>
                    </div>
                    </div>
                </div>

@endsection
@push('script')
<script>
    "use strict";
    let methodFieldsData = @json(
        $vendor_withdrawal_methods->mapWithKeys(function ($item) {
            return [$item->id => json_decode($item->method_fields, true)];
        })
    );

    let otherMethodIds = @json($withdrawal_methods->pluck('id')->toArray());

    $(document).on('change', '#withdraw_method', function () {
        let selectedId = $(this).val();
        let containerMy = $('#method-fields-container');
        let containerOther = $('#method-fields-div');

        // Clear both containers
        containerMy.html('');
        containerOther.html('');

        // CASE 1: "My Method" — render from local JS data
        if (methodFieldsData[selectedId]) {
            $.each(methodFieldsData[selectedId], function (key, value) {
                let label = key.replace(/_/g, ' ').replace(/\b\w/g, c => c.toUpperCase());

                let input = `
                    <div class="form-group">
                        <label class="form-label">${label}</label>
                        <input type="text" name="${key}" class="form-control" value="${value ?? ''}">
                    </div>
                `;
                containerMy.append(input);
            });
        }

        // CASE 2: "Others" — fetch method fields via AJAX
        else if (otherMethodIds.includes(parseInt(selectedId))) {

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "{{ route('vendor.wallet.method-list') }}?method_id=" + selectedId,
                type: 'get',
                success: function (response) {
                    let method_fields = response.content.method_fields;

                    if (!method_fields || method_fields.length === 0) {
                        containerOther.html('<p>No fields available for this method.</p>');
                        return;
                    }

                    containerOther.html(''); // Clear previous

                    method_fields.forEach(field => {
                        let label = field.input_name.replace(/_/g, ' ').replace(/\b\w/g, c => c.toUpperCase());
                        let inputType = (field.input_type === 'phone') ? 'number' : field.input_type;

                        containerOther.append(`
                            <div class="form-group mt-2">
                                <label class="fz-16 text-capitalize c1 mb-2">${label}</label>
                                <input type="${inputType}"
                                       class="form-control"
                                       name="${field.input_name}"
                                       placeholder="${field.placeholder}"
                                       ${field.is_required === 1 ? 'required' : ''}>
                            </div>
                        `);
                    });
                },
                error: function () {
                    alert('Failed to load method fields.');
                }
            });
        }
    });

    $('.payment-warning').on('click',function (event ){
            event.preventDefault();
            toastr.info(
                "{{ translate('messages.Currently,_there_are_no_payment_options_available._Please_contact_admin_regarding_any_payment_process_or_queries.') }}", {
                    CloseButton: true,
                    ProgressBar: true
                });
        });

    function showMyModal(data) {
        $(".modal-body #hiddenValue").html(data);
        $('#exampleModal').modal('show');
    }


    $('.withdrawal-methods-disable').on('click', function (){
    toastr.info( $(this).data('message') , {
        CloseButton: true,
        ProgressBar: true
    });
})

$(document).ready(function() {
    $("#withdraw_form").on("submit", function(event) {
        $('#set_disable').attr('disabled', true);

    });
});

    document.addEventListener('DOMContentLoaded', function () {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });



</script>
@endpush
