<?php $__env->startSection('title',$restaurant->name); ?>

<?php $__env->startPush('css_or_js'); ?>
    <!-- Custom styles for this page -->
    <link href="<?php echo e(dynamicAsset('public/assets/admin/css/croppie.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="d-flex flex-wrap justify-content-between align-items-center">
            <h1 class="page-header-title text-break">
                <i class="tio-museum"></i> <span><?php echo e($restaurant->name); ?></span>
            </h1>
        </div>
        <!-- Nav Scroller -->
        <div class="js-nav-scroller hs-nav-scroller-horizontal">
            <span class="hs-nav-scroller-arrow-prev initial-hidden">
                <a class="hs-nav-scroller-arrow-link" href="javascript:;">
                    <i class="tio-chevron-left"></i>
                </a>
            </span>

            <span class="hs-nav-scroller-arrow-next initial-hidden">
                <a class="hs-nav-scroller-arrow-link" href="javascript:;">
                    <i class="tio-chevron-right"></i>
                </a>
            </span>

            <!-- Nav -->
            <?php echo $__env->make('admin-views.vendor.view.partials._header',['restaurant'=>$restaurant], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- End Nav -->
        </div>
        <!-- End Nav Scroller -->
    </div>
    <!-- End Page Header -->
    <div class="card">
        <!-- Nav -->
        <div class="card-header border-0 py-2">
            <div class="search--button-wrapper">
                <ul class="nav nav-tabs mr-auto transaction--table-nav">
                    <li class="nav-item">
                        <?php ($account_transaction = \App\Models\AccountTransaction::where('from_type', 'restaurant')->where('type', 'collected')->where('from_id', $restaurant->vendor->id)->count()); ?>
                        <?php ($account_transaction = isset($account_transaction) ? $account_transaction : 0); ?>
                        <a class="nav-link text-capitalize <?php echo e($sub_tab=='cash'?'active':''); ?>" href="<?php echo e(route('admin.restaurant.view', ['restaurant'=>$restaurant->id, 'tab'=> 'transaction', 'sub_tab'=>'cash'])); ?>"  aria-disabled="true">
                            <?php echo e(translate('messages.cash_collected_by_admin')); ?> (<?php echo e($account_transaction); ?>)
                        </a>
                    </li>
                    <li class="nav-item">
                        <?php ($digital_transaction = \App\Models\OrderTransaction::where('vendor_id', $restaurant->vendor->id)->count()); ?>
                        <?php ($digital_transaction = isset($digital_transaction) ? $digital_transaction : 0); ?>
                        <a class="nav-link text-capitalize <?php echo e($sub_tab=='digital'?'active':''); ?>" href="<?php echo e(route('admin.restaurant.view', ['restaurant'=>$restaurant->id, 'tab'=> 'transaction', 'sub_tab'=>'digital'])); ?>"  aria-disabled="true">
                            <?php echo e(translate('messages.order_collected_by_admin')); ?> (<?php echo e($digital_transaction); ?>)
                        </a>
                    </li>
                    <li class="nav-item">
                        <?php ($withdraw_transaction = \App\Models\WithdrawRequest::where('vendor_id',$restaurant->vendor->id)->count()); ?>
                        <?php ($withdraw_transaction = isset($withdraw_transaction) ? $withdraw_transaction : 0); ?>
                        <a class="nav-link text-capitalize <?php echo e($sub_tab=='withdraw'?'active':''); ?>" href="<?php echo e(route('admin.restaurant.view', ['restaurant'=>$restaurant->id, 'tab'=> 'transaction', 'sub_tab'=>'withdraw'])); ?>"  aria-disabled="true">
                            <?php echo e(translate('messages.withdraws')); ?> (<?php echo e($withdraw_transaction); ?>)
                        </a>
                    </li>
                </ul>
                <!-- Export Button Static -->
                <div class="hs-unfold ml-3 mr-3">
                    <a class="js-hs-unfold-invoker btn btn-sm btn-white dropdown-toggle btn export-btn btn-outline-primary btn--primary font--sm" href="javascript:;"
                    data-hs-unfold-options='{
                        "target": "#usersExportDropdown",
                        "type": "css-animation"
                    }'>
                    <i class="tio-download-to mr-1"></i> <?php echo e(translate('messages.export')); ?>

                </a>
                    <?php if($sub_tab=='cash'): ?>
                    <div id="usersExportDropdown" class="hs-unfold-content dropdown-unfold dropdown-menu dropdown-menu-sm-right">
                        <span class="dropdown-header"><?php echo e(translate('messages.download_options')); ?></span>
                        <a id="export-excel" class="dropdown-item" href="<?php echo e(route('admin.restaurant.cash-transaction-export', ['restaurant'=>$restaurant->vendor->id,'type'=>'excel'])); ?>">
                            <img class="avatar avatar-xss avatar-4by3 mr-2"
                                    src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/excel.svg"
                                    alt="Image Description">
                            <?php echo e(translate('messages.excel')); ?>

                        </a>
                        <a id="export-csv" class="dropdown-item" href="<?php echo e(route('admin.restaurant.cash-transaction-export', ['restaurant'=>$restaurant->vendor->id,'type'=>'csv'])); ?>">
                            <img class="avatar avatar-xss avatar-4by3 mr-2"
                                    src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/placeholder-csv-format.svg"
                                    alt="Image Description">
                            <?php echo e(translate('messages.csv')); ?>

                        </a>
                    </div>
                    <?php elseif($sub_tab=='digital'): ?>
                    <div id="usersExportDropdown" class="hs-unfold-content dropdown-unfold dropdown-menu dropdown-menu-sm-right">
                        <span class="dropdown-header"><?php echo e(translate('messages.download_options')); ?></span>
                        <a id="export-excel" class="dropdown-item" href="<?php echo e(route('admin.restaurant.digital-transaction-export', ['restaurant'=>$restaurant->vendor->id,'type'=>'excel'])); ?>">
                            <img class="avatar avatar-xss avatar-4by3 mr-2"
                                    src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/excel.svg"
                                    alt="Image Description">
                            <?php echo e(translate('messages.excel')); ?>

                        </a>
                        <a id="export-csv" class="dropdown-item" href="<?php echo e(route('admin.restaurant.digital-transaction-export', ['restaurant'=>$restaurant->vendor->id,'type'=>'csv'])); ?>">
                            <img class="avatar avatar-xss avatar-4by3 mr-2"
                                    src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/placeholder-csv-format.svg"
                                    alt="Image Description">
                            <?php echo e(translate('messages.csv')); ?>

                        </a>
                    </div>
                    <?php elseif($sub_tab=='withdraw'): ?>
                    <div id="usersExportDropdown" class="hs-unfold-content dropdown-unfold dropdown-menu dropdown-menu-sm-right">
                        <span class="dropdown-header"><?php echo e(translate('messages.download_options')); ?></span>
                        <a id="export-excel" class="dropdown-item" href="<?php echo e(route('admin.restaurant.withdraw-transaction-export', ['restaurant'=>$restaurant->vendor->id,'type'=>'excel'])); ?>">
                            <img class="avatar avatar-xss avatar-4by3 mr-2"
                                    src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/excel.svg"
                                    alt="Image Description">
                            <?php echo e(translate('messages.excel')); ?>

                        </a>
                        <a id="export-csv" class="dropdown-item" href="<?php echo e(route('admin.restaurant.withdraw-transaction-export', ['restaurant'=>$restaurant->vendor->id,'type'=>'csv'])); ?>">
                            <img class="avatar avatar-xss avatar-4by3 mr-2"
                                    src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/placeholder-csv-format.svg"
                                    alt="Image Description">
                            <?php echo e(translate('messages.csv')); ?>

                        </a>
                    </div>
                    <?php endif; ?>
                </div>
                <!-- Export Button Static -->
            </div>
        </div>
        <!-- End Nav -->

        <div class="card-body p-0">
        <?php if($sub_tab=='cash'): ?>
            <?php echo $__env->make('admin-views.vendor.view.partials.cash_transaction', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php elseif($sub_tab=='digital'): ?>
            <?php echo $__env->make('admin-views.vendor.view.partials.digital_transaction', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php elseif($sub_tab=='withdraw'): ?>
            <?php echo $__env->make('admin-views.vendor.view.partials.withdraw_transaction', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        <?php endif; ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/helloidly/public_html/admin.helloidly.com/resources/views/admin-views/vendor/view/transaction.blade.php ENDPATH**/ ?>