<?php $__env->startSection('title',translate('messages.Add_new_sub_category')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col-sm mb-2 mb-sm-0">
                    <h1 class="page-header-title">
                        <div class="card-header-icon d-inline-flex mr-2 img">
                            <img src="<?php echo e(dynamicAsset('public/assets/admin/img/sub-category.png')); ?>" alt="">
                        </div>
                        <span><?php echo e(translate('messages.Sub_Category_Setup')); ?></span>
                    </h1>
                </div>
            </div>
        </div>
        <!-- End Page Header -->
        <div class="card mb-20 resturant--cate-form">
            <div class="card-body">
                <form action="<?php echo e(isset($category)?route('admin.category.update',[$category['id']]):route('admin.category.store')); ?>" method="post">
                <?php echo csrf_field(); ?>
                    <div class="global-bg-box p-xxl-4 p-3 rounded">
                        <?php ($language=\App\Models\BusinessSetting::where('key','language')->first()); ?>
                        <?php ($language = $language->value ?? null); ?>
                        <?php ($default_lang = str_replace('_', '-', app()->getLocale())); ?>
                        <?php if($language): ?>
                        <div class="js-nav-scroller tabs-slide-language hs-nav-scroller-horizontal">
                            <ul class="nav nav-tabs mb-4 border-0">
                                <li class="nav-item">
                                    <a class="nav-link lang_link active" href="#" id="default-link"><?php echo e(translate('Default')); ?></a>
                                </li>
                                <?php $__currentLoopData = json_decode($language); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a class="nav-link lang_link" href="#" id="<?php echo e($lang); ?>-link"><?php echo e(\App\CentralLogics\Helpers::get_language_name($lang).'('.strtoupper($lang).')'); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="arrow-area">
                                <div class="button-prev align-items-center">
                                    <button type="button"
                                        class="btn btn-click-prev mr-auto border-0 btn-primary rounded-circle fs-12 p-2 d-center">
                                        <i class="tio-chevron-left fs-24"></i>
                                    </button>
                                </div>
                                <div class="button-next align-items-center">
                                    <button type="button"
                                        class="btn btn-click-next ml-auto border-0 btn-primary rounded-circle fs-12 p-2 d-center">
                                        <i class="tio-chevron-right fs-24"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="input-label"
                                        for="parent_id"><?php echo e(translate('messages.main_category')); ?>

                                        <span class="form-label-secondary text-danger" data-toggle="tooltip"
                                              data-placement="right"
                                              data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                    </span></label>
                                    <select id="parent_id" name="parent_id" class="form-control js-select2-custom" required>
                                        <option value="" selected disabled><?php echo e(translate('Select_Category')); ?></option>
                                        <?php $__currentLoopData = \App\Models\Category::where(['position'=>0])->get(['id','name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cat['id']); ?>" <?php echo e(isset($category)?($category['parent_id']==$cat['id']?'selected':''):''); ?> ><?php echo e($cat['name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <input name="position" value="1" type="hidden">
                            </div>
                            <div class="col-md-6">

                                <div class="form-group lang_form" id="default-form">
                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('messages.name')); ?> (<?php echo e(translate('Default')); ?>)
                                        <span class="form-label-secondary text-danger" data-toggle="tooltip"
                                              data-placement="right"
                                              data-original-title="<?php echo e(translate('messages.Required.')); ?>"> *
                                    </span>
                                    </label>
                                    <input required type="text" name="name[]" class="form-control" placeholder="<?php echo e(translate('Ex:_Sub_Category_Name')); ?>"   maxlength="191">
                                </div>

                                <input type="hidden" name="lang[]" value="default">

                            <?php $__currentLoopData = json_decode($language); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-group d-none lang_form" id="<?php echo e($lang); ?>-form">
                                        <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('messages.name')); ?> (<?php echo e(strtoupper($lang)); ?>)
                                            <span
                                            class="input-label-secondary" data-toggle="tooltip"
                                            data-placement="right"
                                            data-original-title="<?php echo e(translate('messages.content need')); ?>"><i class="tio-info text-gray1 fs-14"></i></span>
                                        </label>
                                        <input type="text" name="name[]" class="form-control" placeholder="<?php echo e(translate('Ex:_Sub_Category_Name')); ?>" maxlength="191"  >
                                    </div>
                                    <input type="hidden" name="lang[]" value="<?php echo e($lang); ?>">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="form-group" id="default-form">
                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('messages.name')); ?> <?php echo e(translate('Default')); ?></label>
                                    <input type="text" name="name[]" class="form-control" placeholder="<?php echo e(translate('Ex:_Sub_Category_Name')); ?>"  maxlength="191">
                                </div>
                                <input type="hidden" name="lang[]" value="default">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="btn--container justify-content-end mt-4">
                        <!-- Static Button -->
                        <button type="reset" id="reset_btn" class="btn btn--reset"><?php echo e(translate('reset')); ?></button>
                        <!-- Static Button -->
                        <button type="submit" class="btn btn--primary"><?php echo e(isset($category)?translate('messages.update'):translate('messages.Add')); ?></button>
                    </div>
                </form>
            </div>
        </div>
        <div class="card mt-2">
            <div class="card-header pt-3 pb-1 border-0">
                <div class="search--button-wrapper">
                    <h5 class="card-title"><?php echo e(translate('messages.sub_category_list')); ?><span class="badge badge-soft-dark ml-2" id="itemCount"><?php echo e($categories->total()); ?></span></h5>
                    <form id="campaignFilterForm" class="align-items-center row row-cols-lg-3 row-gap-1">
                        <div class="col-md-6 w-18rem">
                                <select id="category" name="category" class="form-control js-select2-custom campaignFilterSelect">
                                    <option value="" <?php echo e(request('category') == '' ? 'selected' : ''); ?>><?php echo e(translate('Select_Category')); ?></option>
                                    <?php $__currentLoopData = \App\Models\Category::where(['position'=>0])->get(['id','name']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cat['id']); ?>" <?php echo e(request('category')==$cat['id']?'selected':''); ?> ><?php echo e($cat['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                        </div>
                        <div class="col-md-6 w-18rem">
                            <select name="priority"
                                    class="form-control select2-basic campaignFilterSelect">
                                <option value="" <?php echo e(request('priority') == '' ? 'selected' : ''); ?>><?php echo e(translate('messages.select_priority')); ?></option>
                                <option value="0" <?php echo e(request('priority') == '0' ? 'selected' : ''); ?>>
                                    <?php echo e(translate('messages.normal')); ?>

                                </option>
                                <option value="1" <?php echo e(request('priority') == '1' ? 'selected' : ''); ?>>
                                    <?php echo e(translate('messages.medium')); ?>

                                </option>
                                <option value="2" <?php echo e(request('priority') == '2' ? 'selected' : ''); ?>>
                                    <?php echo e(translate('messages.high')); ?>

                                </option>
                            </select>
                        </div>
                        <div class="col-md-6 w-18rem">
                            <div class="input--group input-group input-group-merge input-group-flush">
                                <input type="search" name="search" value="<?php echo e(request()?->search ?? null); ?>"
                                       class="form-control" placeholder="<?php echo e(translate('Ex_:_Categories')); ?>"
                                       aria-label="<?php echo e(translate('messages.search_categories')); ?>">
                                <button type="submit" class="btn btn--secondary secondary-cmn"><i class="tio-search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                    <div class="hs-unfold ml-3">
                        <a class="js-hs-unfold-invoker btn btn-sm btn-white dropdown-toggle btn export-btn btn-outline-primary btn--primary font--sm" href="javascript:;"
                            data-hs-unfold-options='{
                                "target": "#usersExportDropdown",
                                "type": "css-animation"
                            }'>
                            <i class="tio-download-to mr-1"></i> <?php echo e(translate('messages.export')); ?>

                        </a>

                        <div id="usersExportDropdown"
                                class="hs-unfold-content dropdown-unfold dropdown-menu dropdown-menu-sm-right">
                            <span class="dropdown-header"><?php echo e(translate('messages.download_options')); ?></span>
                            <a target="__blank" id="export-excel" class="dropdown-item" href="<?php echo e(route('admin.category.export-sub-categories', ['type'=>'excel', request()->getQueryString()])); ?>">
                                <img class="avatar avatar-xss avatar-4by3 mr-2"
                                        src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/excel.svg"
                                        alt="Image Description">
                                <?php echo e(translate('messages.excel')); ?>

                            </a>
                            <a target="__blank" id="export-csv" class="dropdown-item" href="<?php echo e(route('admin.category.export-sub-categories', ['type'=>'csv', request()->getQueryString()])); ?>">
                                <img class="avatar avatar-xss avatar-4by3 mr-2"
                                        src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/svg/components/placeholder-csv-format.svg"
                                        alt="Image Description">
                                <?php echo e(translate('messages.csv')); ?>

                            </a>
                        </div>
                    </div>
                    <div class="hs-unfold ml-3">
                        <a class="btn min-w-100px justify-content-center font-medium btn-sm offcanvas-trigger btn-outline-primary" href="javascript:" data-target="#offcanvas__subcate">
                            <i class="tio-tune-horizontal mr-1 fs-16"></i> <span class="mt-1"><?php echo e(translate('Filter')); ?></span>
                        </a>
                    </div>
                </div>
            </div>
            <div class="card-body px-0 pt-0">
                <div class="table-responsive datatable-custom">
                    <table id="columnSearchDatatable"
                        class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table"
                        data-hs-datatables-options='{
                            "search": "#datatableSearch",
                            "entries": "#datatableEntries",
                            "isResponsive": false,
                            "isShowPaging": false,
                            "paging":false,
                        }'>
                        <thead class="thead-light">
                            <tr>
                                <th><?php echo e(translate('messages.sl')); ?></th>
                                <th><?php echo e(translate('messages.sub_category')); ?></th>
                                <th><?php echo e(translate('messages.id')); ?></th>
                                <th><?php echo e(translate('messages.main_category')); ?></th>
                                <th>
                                    <div class=""> <?php echo e(translate('messages.priority level')); ?>

                                        <span class="input-label-secondary" data-toggle="tooltip" data-placement="right"
                                                data-original-title="<?php echo e(translate('Set how prominently this sub-category should appear to customers')); ?>"><i class="tio-info text-gray1 fs-14"></i></span>
                                    </div>
                                </th>
                                <th class="w-100px"><?php echo e(translate('messages.status')); ?></th>
                                <th class="text-center"><?php echo e(translate('messages.action')); ?></th>
                            </tr>
                        </thead>

                        <tbody id="table-div">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($key+$categories->firstItem()); ?></td>
                                <td>
                                    <span class="d-block font-size-sm text-body">
                                        <?php echo e(Str::limit($category->name,20,'...')); ?>

                                    </span>
                                </td>
                                <td><?php echo e($category->id); ?></td>
                                <td>
                                    <span class="d-block font-size-sm text-body">
                                        <?php echo e(Str::limit($category?->parent?->name,20,'...')); ?>

                                    </span>
                                </td>
                                <td>
                                    <form action="<?php echo e(route('admin.category.priority',$category->id)); ?>" class="priority-form">
                                    <select name="priority" id="priority" class="form-control form--control-select priority-select <?php echo e($category->priority == 0 ? 'text--title border-dark':''); ?> <?php echo e($category->priority == 1 ? 'text--info border-info':''); ?> <?php echo e($category->priority == 2 ? 'text--success border-success':''); ?> ">
                                        <option value="0" <?php echo e($category->priority == 0?'selected':''); ?>><?php echo e(translate('messages.normal')); ?></option>
                                        <option value="1" <?php echo e($category->priority == 1?'selected':''); ?>><?php echo e(translate('messages.medium')); ?></option>
                                        <option value="2" <?php echo e($category->priority == 2?'selected':''); ?>><?php echo e(translate('messages.high')); ?></option>
                                    </select>
                                    </form>
                                </td>
                                <td>
                                    <label class="toggle-switch toggle-switch-sm" for="stocksCheckbox<?php echo e($category->id); ?>">
                                    <input type="checkbox" data-url="<?php echo e(route('admin.category.status',[$category['id'],$category->status?0:1])); ?>" class="toggle-switch-input redirect-url" id="stocksCheckbox<?php echo e($category->id); ?>" <?php echo e($category->status?'checked':''); ?>>
                                        <span class="toggle-switch-label">
                                            <span class="toggle-switch-indicator"></span>
                                        </span>
                                    </label>
                                </td>
                                <td>
                                    <div class="btn--container justify-content-center">
                                        <a class="btn btn-sm text-end action-btn info--outline text--info info-hover offcanvas-trigger get_data data-info-show"
                                           data-target="#offcanvas__customBtn3" data-id="<?php echo e($category['id']); ?>"
                                           data-url="<?php echo e(route('admin.category.edit', [$category['id']])); ?>"
                                           data-model="sub"
                                           href="javascript:" title="<?php echo e(translate('messages.edit_sub_category')); ?>"><i
                                                class="tio-edit"></i>
                                        </a>
                                        <a class="btn btn-sm btn--danger btn-outline-danger action-btn form-alert" href="javascript:"
                                        data-id="category-<?php echo e($category['id']); ?>" data-message="<?php echo e(translate('Want_to_delete_this_sub_category_?')); ?>" title="<?php echo e(translate('messages.delete_sub_category')); ?>"><i class="tio-delete-outlined"></i>
                                        </a>
                                    </div>
                                    <form action="<?php echo e(route('admin.category.delete',[$category['id']])); ?>" method="post" id="category-<?php echo e($category['id']); ?>">
                                        <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <?php if(count($categories) === 0): ?>
                    <div class="empty--data">
                        <img src="<?php echo e(dynamicAsset('/public/assets/admin/img/empty.png')); ?>" alt="public">
                        <h5>
                            <?php echo e(translate('no_data_found')); ?>

                        </h5>
                    </div>
                    <?php endif; ?>
                    <div class="page-area px-4 pt-3 pb-0">
                        <div class="d-flex align-items-center justify-content-end">
                            <div>
                    <?php echo $categories->links(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div id="offcanvas__customBtn3" class="custom-offcanvas d-flex flex-column justify-content-between">
        <div id="data-view" class="h-100">
        </div>
    </div>

    <div id="offcanvas__subcate" class="custom-offcanvas"
        style="--offcanvas-width: 500px">
        <form method="GET" class="d-flex flex-column justify-content-between">
            <div class="custom-offcanvas-header d-flex justify-content-between align-items-center">
                <div class="px-3 py-3 d-flex justify-content-between w-100">
                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <h2 class="mb-0 fs-18 text-title font-medium"><?php echo e(translate('Sub Category Filter')); ?></h2>
                    </div>
                    <button type="button"
                        class="btn-close w-25px h-25px border rounded-circle d-center bg--secondary offcanvas-close fz-15px p-0"
                        aria-label="Close">&times;
                    </button>
                </div>
            </div>
            <div>
                <div class="custom-offcanvas-body p-20">
                    <input type="hidden" name="search" value="<?php echo e(request()->query('search')); ?>">
                    <div class="d-flex flex-column gap-20px">
                        <div class="global-bg-box rounded p-xl-20 p-16">
                            <h5 class="mb-10px font-regular text-color font-normal"><?php echo e(translate('Status')); ?></h5>
                            <div class="bg-white rounded p-xl-3 p-2">
                                <div class="row gx-xl-3 gx-2 gy-xl-3 gy-2">
                                    <div class="col-sm-6 col-auto">
                                        <div class="form-group m-0">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="active__status" name="status[]" value="1" <?php echo e(in_array('1', (array) request()->query('status', [])) ? 'checked' : ''); ?>>
                                                <label class="custom-control-label text-title" for="active__status">
                                                    <?php echo e(translate('messages.Active')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-auto">
                                        <div class="form-group m-0">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="inactive__status" name="status[]" value="0" <?php echo e(in_array('0', (array) request()->query('status', [])) ? 'checked' : ''); ?>>
                                                <label class="custom-control-label text-title" for="inactive__status">
                                                    <?php echo e(translate('messages.Inactive')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="global-bg-box rounded p-xl-20 p-16">
                            <h5 class="mb-10px font-regular text-color font-normal"><?php echo e(translate('Priority')); ?> </h5>
                            <div class="bg-white rounded p-xl-3 p-2">
                                <div class="row gx-xl-3 gx-2 gy-xl-3 gy-2 order-status_controller ">
                                    <div class="col-sm-6 col-md-4 col-auto">
                                        <div class="form-group m-0">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="priority_2" name="priority[]" value="2" <?php echo e(in_array('2', (array) request()->query('priority', [])) ? 'checked' : ''); ?>>
                                                <label class="custom-control-label text-title" for="priority_2">
                                                <?php echo e(translate('messages.High')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-4 col-auto">
                                        <div class="form-group m-0">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="priority_1" name="priority[]" value="1" <?php echo e(in_array('1', (array) request()->query('priority', [])) ? 'checked' : ''); ?>>
                                                <label class="custom-control-label text-title" for="priority_1">
                                                <?php echo e(translate('messages.Medium')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-4 col-auto">
                                        <div class="form-group m-0">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="priority_0" name="priority[]" value="0" <?php echo e(in_array('0', (array) request()->query('priority', [])) ? 'checked' : ''); ?>>
                                                <label class="custom-control-label text-title" for="priority_0">
                                                <?php echo e(translate('messages.Normal')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="global-bg-box rounded p-xl-20 p-16">
                            <h5 class="mb-10px font-regular text-color font-normal"><?php echo e(translate('Category ')); ?> </h5>
                            <div class="bg-white rounded p-xl-3 p-2">
                                <div class="row gx-xl-3 gx-2 gy-xl-3 gy-2 order-status_controller custom__select-controller ">
                                    <div class="col-sm-6 col-auto">
                                        <div class="form-group m-0">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input check-all" id="all" name="category[]" value="all">
                                                <label class="custom-control-label text-title" for="all">
                                                    <?php echo e(translate('messages.All')); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <?php $__currentLoopData = \App\Models\Category::where(['position'=>0])->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-sm-6 col-auto">
                                        <div class="form-group m-0">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input"
                                                    id="category_<?php echo e($category->id); ?>"
                                                    name="category[]"
                                                    value="<?php echo e($category->id); ?>"
                                                    <?php echo e(in_array($category->id, (array) request()->query('category', [])) ? 'checked' : ''); ?>>
                                                <label class="custom-control-label text-title" for="category_<?php echo e($category->id); ?>">
                                                    <?php echo e(translate('messages.' . $category->name)); ?>

                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-sm-12">
                                        <div class="text-center w-100">
                                            <button type="button" class="see__more btn mx-auto d-flex fs-12 align-items-center justify-content-center gap-1 p-0 border-0 text--primary font-semibold text-center">
                                                <?php echo e(translate('See More')); ?> <span class="text-primary count"></span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="align-items-center h-84px bg-white bottom-0 d-flex gap-3 justify-content-center offcanvas-footer p-3 position-absolute w-100">
                <a href="#0" class="btn w-100 btn--reset offcanvas-close"><?php echo e(translate('Reset')); ?></a>
                <button type="submit" class="btn w-100 btn--primary"><?php echo e(translate('Apply')); ?></button>
            </div>
        </form>
    </div>


    <div id="offcanvasOverlay" class="offcanvas-overlay"></div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(dynamicAsset('public/assets/admin')); ?>/js/view-pages/sub-category-index.js"></script>
    <script src="<?php echo e(dynamicAsset('public/assets/admin/js/offcanvas.js')); ?>"></script>

    <script>
        "use strict";
        document.addEventListener("DOMContentLoaded", function () {
            const form = document.getElementById("campaignFilterForm");
            const filterSelect = document.querySelector(".campaignFilterSelect")

            if (filterSelect && form) {
                filterSelect.addEventListener("change", function () {
                    form.submit();
                });
            }

            $('.select2-basic').select2({
                width: '100%'
            });

            $('.campaignFilterSelect').on('change', function () {
                $('#campaignFilterForm').submit();
            });
        });
        $(document).on('click', '.data-info-show', function() {
            let id = $(this).data('id');
            let url = $(this).data('url');
            let model = $(this).data('model');
            fetch_data(id, url, model)
        })

        function fetch_data(id, url, model='category') {
            $.ajax({
                url: url,
                type: "get",
                data: {
                    id: id,
                    model: model
                },
                beforeSend: function() {
                    $('#data-view').empty();
                    $('#loading').show()
                },
                success: function(data) {
                    $("#data-view").append(data.view);
                    initLangTabs();
                    initSelect2Dropdowns();
                },
                complete: function() {
                    $('#loading').hide()
                }
            })
        }



        function initLangTabs() {
            const langLinks = document.querySelectorAll(".lang_link1");
            langLinks.forEach(function(langLink) {
                langLink.addEventListener("click", function(e) {
                    e.preventDefault();
                    langLinks.forEach(function(link) {
                        link.classList.remove("active");
                    });
                    this.classList.add("active");
                    document.querySelectorAll(".lang_form1").forEach(function(form) {
                        form.classList.add("d-none");
                    });
                    let form_id = this.id;
                    let lang = form_id.substring(0, form_id.length - 5);
                    $("#" + lang + "-form1").removeClass("d-none");
                    if (lang === "default") {
                        $(".default-form1").removeClass("d-none");
                    }
                });
            });
        }

        function initSelect2Dropdowns() {
            $('.js-select2-custom1').select2({
                placeholder: 'Select tax rate',
                allowClear: true
            });
            $('.offcanvas-close, #offcanvasOverlay').on('click', function () {
                $('.custom-offcanvas').removeClass('open');
                $('#offcanvasOverlay').removeClass('show');
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/helloidly/public_html/admin.helloidly.com/resources/views/admin-views/category/sub-index.blade.php ENDPATH**/ ?>